<style>
    .comment-container {
        margin-bottom: 20px;
        padding: 10px;
        border: 1px solid #ccc;
        background-color: #f9f9f9;
    }

    .reply-container {
        margin-left: 20px;
        padding: 10px;
        border: 1px solid #ccc;
        background-color: #f1f1f1;
    }
</style>

<div class="comment_load_show " data-items="5">
    <div class="itemReview mb-40">

        <div class="small-tittle mb-24">
            <h3><?php echo e(__('Comments')); ?> (<?php echo e($commentCount); ?>)</h3>
        </div>

        <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="singleReview blog_comment_container">
                <div class="client1Img">
                    <?php echo render_image_markup_by_attachment_id($comment->user?->image,'thumb'); ?>

                </div>
                <div class="reviewText">
                    <div class="d-flex align-items-center">
                        <h3><?php echo e($comment->user?->name); ?></h3>
                    </div>
                    <span> <?php echo e($comment->created_at?->format('M d, Y')); ?></span>
                    <p>
                        <?php echo purify_html($comment->comment_content ?? ''); ?>

                    </p>

                    <?php if($comment->comment_replay): ?>
                    <div class="reply-container mt-3">
                        <div class="d-flex align-items-center">
                            <h3>  <b class="badge bg-secondary">Author</b></h3>
                        </div>
                        <span> <?php echo e($comment->comment_replay ? $comment->comment_replay->created_at?->format('M d, Y'): ''); ?></span>
                        <p> <?php echo e($comment->comment_replay ? $comment->comment_replay->comment_content : ""); ?></p>
                    </div>
                    <?php endif; ?>
                    <?php if(is_null($comment->comment_replay) && auth()->guard('admin')): ?>
                        <div>
                            <button type="button" id="showInput" data-id="<?php echo e($comment->id); ?>" class="btn btn-outline-secondary float-sm-end mb-3 ShowInput">
                                <?php echo e(__('Reply')); ?></button>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

        <div id="inputContainer_<?php echo e($comment->id); ?>" style="display: none;">
            <form action="" class="contactUs mb-5" id="blog-comment-form" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="user_id" value="<?php echo e(auth()->guard('web')->id()); ?>">
                <input type="hidden" name="blog_id" value="<?php echo e($blog->id); ?>">
                <input type="hidden" id="parent_id_<?php echo e($comment->id); ?>" name="parent_id" value="<?php echo e($comment->id); ?>">

                <div class="error-message"></div>
                <div class="col-lg-12">
                    <div class="input-form input-form2">
                        <input placeholder="<?php echo e(__('write anything')); ?>" type="text" id="comment_content_<?php echo e($comment->id); ?>" name="comment_content" value="">
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="btn-wrapper mb-10">
                        <button type="button" onClick="blogReply(<?php echo e($comment->id); ?>)"  class="cmn-btn1"><?php echo e(__('Reply')); ?></button>
                    </div>
                </div>
            </form>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>
</div>


<?php if($commentCount): ?>
    <?php if($commentCount > 5): ?>
        <div class="btn-wrapper load_more_container">
            <a href="javascript:void(0)" class="cmn-btn1 w-100 mb-40 load_more_button"><?php echo e(__('Load More')); ?></a>
        </div>
    <?php endif; ?>
<?php endif; ?>


<?php /**PATH /home/shakuniya/builder.shakuniya.in/core/Modules/Blog/Resources/views/components/frontend/comment-list.blade.php ENDPATH**/ ?>