@extends('tenant.frontend.user.dashboard.user-master')
@section('title')
    {{__('Menu Order View')}}
@endsection
@section('style')
    <x-summernote.css/>
    <style>
        span.low,
        span.status-open {
            display: inline-block;
            background-color: #6bb17b;
            padding: 3px 10px;
            border-radius: 4px;
            color: #fff;
            text-transform: capitalize;
            border: none;
            font-weight: 600;
            font-size: 10px;
            margin: 3px;
        }

        span.high,
        span.status-close {
            display: inline-block;
            background-color: #c66060;
            padding: 3px 10px;
            border-radius: 4px;
            color: #fff;
            text-transform: capitalize;
            border: none;
            font-weight: 600;
            font-size: 10px;
            margin: 3px;
        }

        span.medium {
            display: inline-block;
            background-color: #70b9ae;
            padding: 3px 10px;
            border-radius: 4px;
            color: #fff;
            text-transform: capitalize;
            border: none;
            font-weight: 600;
            font-size: 10px;
            margin: 3px;
        }

        span.urgent {
            display: inline-block;
            background-color: #bfb55a;
            padding: 3px 10px;
            border-radius: 4px;
            color: #fff;
            text-transform: capitalize;
            border: none;
            font-weight: 600;
            font-size: 10px;
            margin: 3px;
        }

        /* support ticket  */

        .reply-message-wrap {
            padding: 40px;
            background-color: #fbf9f9;
        }

        .gig-message-start-wrap {
            margin-top: 60px;
            margin-bottom: 60px;
            background-color: #fbf9f9;
            padding: 40px;
        }

        .single-message-item {
            background-color: #e7ebec;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            margin-right: 80px;
        }

        .reply-message-wrap .title {
            font-size: 22px;
            line-height: 32px;
            margin-bottom: 40px;
            font-weight: 600;
        }

        .single-message-item.customer {
            background-color: #dadde0;
            text-align: left;
            margin-right: 0;
        }

        .reply-message-wrap .title {
            font-size: 22px;
            line-height: 32px;
            margin-bottom: 40px;
            font-weight: 600;
        }

        .gig-message-start-wrap .boxed-btn {
            padding: 8px 10px;
        }

        .reply-message-wrap .boxed-btn {
            padding: 8px 20px;
            font-size: 14px;
            font-weight: 500;
        }

        .reply-message-wrap textarea:focus {
            outline: none;
            box-shadow: none;
        }

        .reply-message-wrap textarea {
            border: 1px solid #e2e2e2;
        }

        .gig-message-start-wrap .title {
            font-size: 20px;
            line-height: 30px;
            margin-bottom: 40px;
            font-weight: 600;
        }

        .single-message-item .thumb .title {
            font-size: 16px;
            font-weight: 600;
            text-transform: uppercase;
            width: 40px;
            height: 40px;
            line-height: 40px;
            background-color: #c7e5ec;
            display: inline-block;
            border-radius: 5px;
            text-align: center;
        }

        .single-message-item .title {
            font-size: 16px;
            line-height: 20px;
            margin: 10px 0 0px 0;
        }

        .single-message-item .time {
            display: block;
            font-size: 13px;
            margin-bottom: 20px;
            font-weight: 500;
            font-style: italic;
        }

        .single-message-item .thumb i {
            display: block;
            width: 100%;
        }

        .single-message-item.customer .thumb .title {
            background-color: #efd2d2;
        }

        .single-message-item .top-part {
            display: flex;
            margin-bottom: 25px;
        }

        .single-message-item .top-part .content {
            flex: 1;
            margin-left: 15px;
        }


        .anchor-btn {
            border-bottom: 1px solid var(--main-color-one);
            color: var(--main-color-one);
            display: inline-block;
        }

        .all-message-wrap.msg-row-reverse {
            display: flex;
            flex-direction: column-reverse;
            position: relative;
        }

        .load_all_conversation:focus {
            outline: none;
        }

        .load_all_conversation {
            border: none;
            background-color: #111D5C;
            border-radius: 30px;
            font-size: 14px;
            line-height: 20px;
            padding: 10px 30px;
            color: #fff;
            cursor: pointer;
            text-transform: capitalize;
            position: absolute;
            top: -20px;
            left: 50%;
            transform: translateX(-50%);
            font-weight: 500;
        }

        .single-message-item ol, .single-message-item ul {
            padding-left: 15px;
        }

        .anchor-btn {
            color: #345990;
            text-decoration: underline;
            margin: 5px 0;
        }
    </style>
@endsection
@section('content')
    <div class="error-page-content padding-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="support-ticket-summery-warp">
                        <div class="gig-chat-message-heading">
                            <div class="header-wrap d-flex justify-content-between">
                                <h4 class="header-title">{{__('Order  Details')}}</h4>
                                <a href="{{route('tenant.user.dashboard.user.order')}}"
                                   class="btn btn-info">{{__('All Orders')}}</a>
                            </div>
                            <div class="gig-order-info">
                                <ul>
                                    <li><strong>{{__('Order ID:')}}</strong> {{$order_details->id}}</li>
                                    <li><strong>{{__('Order date:')}}</strong> {{$order_details->created_at->format('D, d M Y')}}</li>

                                    <h4 class="header-title mt-3 mb-2">{{__('Billing  Details')}}:</h4>
                                    @if($order_details->menu_billing)
                                    <li><strong>{{__('Name:')}}</strong> {{$order_details->menu_billing?->name}}</li>
                                    <li><strong>{{__('Email:')}}</strong> {{$order_details->menu_billing?->email}}</li>
                                    <li><strong>{{__('Mobile:')}}</strong> {{$order_details->menu_billing?->phone}} </li>
                                    <li><strong>{{__('Address-1:')}}</strong> {{$order_details->menu_billing?->address}} </li>
                                    <li><strong>{{__('Address-2:')}}</strong> {{$order_details->menu_billing?->address_two}} </li>
                                    @else
                                        <span>No Data Available</span>
                                    @endif


                                    <h4 class="header-title mt-3 mb-2">{{__('Shipping Details')}}:</h4>
                                    @if($order_details->menu_shipping)
                                    <li><strong>{{__('Name:')}}</strong> {{$order_details->menu_shipping?->name}}</li>
                                    <li><strong>{{__('Email:')}}</strong> {{$order_details->menu_shipping?->email}}</li>
                                    <li><strong>{{__('Mobile:')}}</strong> {{$order_details->menu_shipping?->phone}} </li>
                                    <li><strong>{{__('Address:')}}</strong> {{$order_details->menu_shipping?->address}} </li>
                                    @else
                                        <span>No Data Available</span>
                                    @endif
                                    <li  class="mt-3">
                                        <strong>{{__('Total Amount:')}}</strong> {{amount_with_currency_symbol($order_details->total_amount)}}
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <x-summernote.js/>
    <script>
        $(document).ready(function () {

            $('.summernote').summernote({
                height: 200,   //set editable area's height
                codemirror: { // codemirror options
                    theme: 'monokai'
                },
                callbacks: {
                    onChange: function (contents, $editable) {
                        $(this).prev('textarea').val(contents);
                    }
                },
                toolbar: [
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['insert', ['link']],
                ],
            });

        });
    </script>
@endsection
